#! /bin/bash

if [ -z ${BPLC} ]; then
    BPLC="bplc"
fi
echo "BPL binary ${BPLC} is used ..."

dir=$(pwd)
failed=0
succeeded=0

for i in $(find . -name \*.bpl); do

    echo -n "Testing $i ... "
    cd $(dirname $i)
    file=$(basename $i)
    firstline=$(head -n 1 ${file})
    if echo ${firstline} | grep -q "^//!"; then
	call="$(echo ${firstline} | sed "s|^//!||" | sed "s| *bplc|${BPLC}|" )"
    else
	call="${BPLC}"
    fi
    file=$(basename $i)
    [ -x ${file%.bpl}.out ] || touch ${file%.bpl}.out
    [ -x ${file%.bpl}.in ] || touch ${file%.bpl}.in
    # echo "${call} ${file} < ${file%.bpl}.in > ${file%.bpl}.tmp 2>&1"
    ${call} ${file} < ${file%.bpl}.in > ${file%.bpl}.tmp 2>&1
    if diff -Nau ${file%.bpl}.out ${file%.bpl}.tmp > ${file%.bpl}.diff; then
	echo "ok"
        succeeded=$((${succeeded} + 1))
        rm ${file%.bpl}.tmp
    else
	echo "failed"
	failed=$((${failed} + 1))
	cat ${file%.bpl}.diff
    fi
    rm ${file%.bpl}.diff
    [ -z "$(cat ${file%.bpl}.out)" ] && rm ${file%.bpl}.out
    [ -z "$(cat ${file%.bpl}.in)" ] && rm ${file%.bpl}.in
    cd ${dir}

done

echo "${failed} of $((succeeded + failed)) tests failed"

