let

/*
type Root <a> = Ref <Tree <a>>

data Tree <a> = Empty | Node ( left = Root <a>, label = a, right = Root <a> )
*/

data Tree <a> = Empty | Node ( left = Ref <Tree <a>>, label = a, right = Ref <Tree <a>> )

type Root <a> = Ref <Tree <a>>

function leaf <a> (elem : a) : Tree <a> =
  Node ( left = ref Empty, label = elem, right = ref Empty )

function insert <a> (ord   : (a, a) -> Bool, 
                     elem  : a, 
                     root  : Root <a>) : () =
  case !root  of  Empty      =>  root := leaf <a> elem
              |   Node node  =>  
                  if ord (elem, node.label)  
                  then  insert <a> (ord, elem, node.left   )
                  else  insert <a> (ord, elem, node.right  )
  end

in
0
end
