let

type Rat = (nominator = Nat, denominator = Nat)

function ggt (a : Nat, b : Nat) : Nat =
  if b == 0 then a
  else if a >= b then ggt (b, a % b)
                 else ggt (b % a, a)

function normalize (rat : Rat) : Rat =
  let  val q = ggt (rat.nominator, rat.denominator)
  in   (  nominator    =  rat.nominator   / q,
          denominator  =  rat.denominator / q)
  end

function add (rat1 : Rat, rat2 : Rat) : Rat =
  normalize (  nominator    =  rat1.nominator * rat2.denominator +
                               rat2.nominator * rat1.denominator,
               denominator  =  rat1.denominator * rat2.denominator)

val r1 = (nominator = 4711, denominator = 19)
val r2 = (nominator =  815, denominator = 149)

in
ggt (2, 0);
ggt (0, 2);
ggt (2 * 3 * 5 * 13, 2 * 5 * 7);
add (r1, r2)
end