let

// double-negation-encoded existentials

type Elim <f,r> = <a> -> f <a> -> r
type Exists <f> = <r> -> Elim <f,r> -> r

// packing a value in an existential
function pack <f> <a> (x : f <a>) : Exists <f> =
  fun <r> (e : Elim <f,r>) => e x

// opening a value is just application ...

// here's an example
type XPair <a>  = (a, a -> Nat)

val concrete = (2, fun (x : Nat) => x)
val hidden   = pack <XPair> concrete

// funnily enough, we must put the type abstraction in the
// eliminator, but we don't have to use it to annotate the argument 
val use = hidden (fun <a> (x, f) => f x)

in

use

end
