// subtyping: a reset-counter can be used for a counter

let

type Reset-Counter = ( get = () -> Nat, inc = () -> (), reset = () -> () )

function new-reset-counter () : Reset-Counter =
    let val x = ref 0 in                // private (instance variables)
      ( get   = \ () => !x,              // public (methods)
        inc   = \ () => x := !x + 1,
        reset = \ () => x := 0 )
    end

in
let
  val c1 = new-reset-counter ()
  val c2 = new-reset-counter ()
in
  System.IO.println (c1.inc ());
  System.IO.println (c2.get ());
  System.IO.println (c1.inc (); c2.inc (); c1.get ())
end
end