// code-reuse via inheritance (subclasses)

let

// internal state

type Counter-Rep = ( x = Ref <Nat> )

// interface (methods)

type Counter = ( get = () -> Nat, inc = () -> () )

function counter-class (rep : Counter-Rep) : Counter =
  ( get   = \ () => !rep.x,
    inc   = \ () => rep.x := !rep.x + 1 )

function new-counter () : Counter =
  counter-class ( x = ref 0)

// subclasses that add new method(s)

type Reset-Counter = ( get = () -> Nat, inc = () -> (), reset = () -> () )

function reset-counter-class (rep : Counter-Rep) : Reset-Counter =
  let val super = counter-class rep in   
  ( get   = super.get,
    inc   = super.inc,
    reset = \ () => rep.x := 0 )
  end

function new-reset-counter () : Reset-Counter =
  reset-counter-class ( x = ref 0)

// subclasses that add new instance variables

type Backup-Counter-Rep = ( x = Ref <Nat>, b = Ref <Nat> )

type Backup-Counter = ( get    = () -> Nat,
                        inc    = () -> (),
                        reset  = () -> (),
                        backup = () -> () )

function backup-counter-class (rep : Backup-Counter-Rep) : Backup-Counter =
  let val super = reset-counter-class rep in   
  ( get    = super.get,
    inc    = super.inc,
    reset  = \ () => rep.x := !rep.b, // overriding the `reset' method
    backup = \ () => rep.b := !rep.x )
  end

function new-backup-counter () : Backup-Counter =
  backup-counter-class ( x = ref 0, b = ref 0 )

// TODO: funny-backup-counter

in
let
  val c1 = new-counter ()
  val c2 = new-reset-counter ()
//  val c2 = new-backup-counter ()
in
  System.IO.println (c1.inc ());
  System.IO.println (c2.get ());
  System.IO.println (c1.inc (); c2.inc (); c2.reset (); c1.get ());
  System.IO.println (c2.get ())
end
end