// echo "46*2+7*." | bplc calculator.bpl
// echo ".56+." | bplc calculator.bpl
// echo ".5x6y+." | bplc calculator.bpl

let

open System.List

type Stack <a> = (  push     =  a     ->  (),
                    isempty  =  ()  ->  Bool,
                    top      =  ()  ->  a,
                    pop      =  ()  ->  a )

exception Top
exception Pop

function new-stack <a> : Stack <a> =
  let val stack = ref Nil in
    (  push      =  fun (x : a) => stack := Cons ( x , !stack ),
       isempty   =  fun () =>  case !stack  
                               of  Nil        => true   
                               |   Cons cons  => false end,
       top       =  fun () =>  case !stack  
                               of  Nil        => throw Top 
                               |   Cons cons  => cons.1 end,
       pop       =  fun () =>  case !stack
                               of  Nil        => throw Pop 
                               |   Cons cons  => stack := cons.2; cons.1 end )
  end

exception Parse

function parse (s : String) : Nat =
  if "0" =< s && s =< "9" 
  then ord s - ord "0"
  else throw Parse

function calculator (stack : Stack <Nat>) : () =
  try
    try
      let  val x = get-char ()
      in   if x == "+" then
             stack.push (stack.pop () + stack.pop ())
           else if x == "*" then
             stack.push (stack.pop () * stack.pop ())
           else if x == "." then
             System.IO.println (stack.top ())
           else
             stack.push (parse x)
      end
    catch
       Pop | Top  => write "stack is empty\n"
    |  Parse      => write "enter a number or an operator\n"
    end ;
    calculator (stack)
  catch
     EOF  => ()
  end
in
calculator (new-stack <Nat>)
end