let

open System.List

function foreach <a> (list : List <a>) : (a -> ()) -> () =
  fun (action : a -> ()) =>
    case list  of  Nil        =>  ()
               |   Cons cons  =>  action (cons.1) ; 
                                  foreach <a> (cons.2) action
    end

function sum (list : List <Nat>) : Nat =
  let  val s = ref 0
  in   foreach <Nat> (list) 
         (fun (n : Nat) => s := !s + n) ; 
       !s
  end

function map <a, b> (f : a -> b) : (List <a> -> List <b>) =
  fun (list : List <a>) =>
    case list  of  Nil        =>  Nil
               |   Cons cons  =>  Cons (  f (cons.1),
                                          map <a, b> f (cons.2) )
    end

function reduce <a, b> (a : b, op : (a, b) -> b) : List <a> -> b =
  fun (list : List <a>) =>
    case list  of  Nil        =>  a
               |   Cons cons  =>  
                     op (cons.1, reduce <a, b> (a, op) (cons.2))
    end

val sum = reduce <Nat, Nat> (0, fun (x,y) => x + y)

in
reduce <Nat, Nat> (1, fun (x,y) => x * y);
reduce <Bool, Bool> (false, \ (a, b) => a || b);
reduce <Bool, Bool> (true, \ (a, b) => a && b);
(fun <a> => reduce <a, List <a>> (Nil, fun (x : a, xs : List <a>) => Cons (x, xs)));
// reduce <a, List <a>> (Nil, fun (x : a, xs : List <a>) => insert <a> (ord, x, xs));
0
end
