//! bplc -l Coroutine.bpl

let

val three : String -> Nat =
    Coroutine.define (\ yield =>
      \ s =>
        write ("a. " + s);
        write ("b. " + yield 1);
        write ("c. " + yield 2);
        3)

val nat : () -> Nat =
    Coroutine.define (\ yield =>
      \ () =>
        let function loop i : Nat = 
              yield i; 
              loop (i + 1)
        in  loop 0
        end)

val fibonacci : () -> Nat =
    Coroutine.define (\ yield =>
      \ () =>
        let function loop (a, b) : Nat = 
              yield a; 
              loop (b, a + b)
        in  loop (0, 1)
        end)

////////////////////////////////////////////////////////////////////////////////

data Tree <a> = Empty | Node ( left = Tree <a>, label = a, right = Tree <a> )

function full (n : Nat) : Tree <Nat> =
  if n == 0 
  then Empty
  else let val t = full (n - 1) 
       in  Node ( left = t, label = n, right = t )
       end

data Maybe <a> = Nothing | Just a

function traverse <a> (root : Tree <a>) : () -> Maybe <a> =
  Coroutine.define (fun yield =>
    fun () =>
      let function inorder (tree : Tree <a>) : () =
            case tree of Empty     => ()
                       | Node node => inorder (node.left);
                                      yield (Just (node.label));
                                      inorder (node.right)
            end
      in inorder root; Nothing end)

function same (g1, g2) : Bool =
  case g1 ()
  of Nothing =>
       case g2 ()
       of Nothing  =>  true
       |  Just _   =>  false
       end
  |  Just a =>
       case g2 ()
       of Nothing  =>  false
       |  Just b   =>  a == b && same (g1, g2)
       end
  end

function samefringe (t1, t2) : Bool = 
    same (traverse t1, traverse t2)

////////////////////////////////////////////////////////////////////////////////

val a1 = ref 0
val a2 = ref 0
val a3 = ref 0
val a4 = ref 0

function flip a : () =
  a := 1 - !a

val poke0 : () -> Bool =
  Coroutine.define (\ yield => \ () =>
    false)

val poke1 : () -> Bool =
  Coroutine.define (\ yield => \ () =>
    System.Control.forever (\ () =>
      flip a1;     // awake
      yield true;  // asleep
      yield (poke0 ()) ))

val poke2 : () -> Bool =
  Coroutine.define (\ yield => \ () =>
    System.Control.forever (\ () =>
      flip a2;     // awake
      yield true;  // asleep
      yield (poke1 ())) )

val poke3 : () -> Bool =
  Coroutine.define (\ yield => \ () =>
    System.Control.forever (\ () =>
      flip a3;     // awake
      yield true;  // asleep
      yield (poke2 ())) )

val poke4 : () -> Bool =
  Coroutine.define (\ yield => \ () =>
    System.Control.forever (\ () =>
      flip a4;     // awake
      yield true;  // asleep
      yield (poke3 ())) )

function lamps () : () =
  write (show (!a1));
  write (show (!a2));
  write (show (!a3));
  write (show (!a4));
  write "\n"

////////////////////////////////////////////////////////////////////////////////

in

write ("1. " + show (three "a\n") + "\n");
write ("2. " + show (three "b\n") + "\n");
write ("3. " + show (three "c\n") + "\n");
write ("4. " + show (three "d\n") + "\n");

System.Control.for (0, 99) (\ i =>
  write (show (nat ()) + ": " + show (fibonacci ()) + "\n"));

let val g = traverse (full 10)
in  System.Control.for (0, 99) (\ i =>
      write (show (g ()) + "\n"))
end;

write (show (samefringe (full 4, full 4)) + "\n");
write (show (samefringe (full 16, full 16)) + "\n");
write (show (samefringe (full 16, full 17)) + "\n");

lamps ();
while poke4() do
  lamps ()
end;
write "----\n";
lamps ();
while poke4() do
   lamps ()
end

end
