//! bplc -l Coroutine.bpl
// echo "A2B5E3426FG0ZYW3210PQ89R" | bplc Coroutine.bpl code.bpl

// Section 1.4.2, TAOCP, Vol. 1

let

module Control = System.Control

type Char = String

function isdigit (c : Char) : Bool =
  48 =< ord c && ord c =< 57

function expand (g : () -> Char) : () -> Char =
  Coroutine.define (\ yield =>
    \ () =>
      System.Control.forever (\ () =>
        let
          val c = g ()
        in
          if isdigit c then
            let
              val c' = g ()
            in
              Control.for (0, ord c - 48) (\ i =>
                yield c'
              )
            end
          else
            yield c
        end))

function out (g : () -> Char) : () -> () =
  Coroutine.define (\ yield =>
    \ () =>
      Control.forever (\ () =>
          Control.for (1, 16) (\ i =>
            write (g ());
            write (g ());
            write (g ());
            write " "
          );
          write "\n"
        ))

in
try out (expand get-char) () catch EOF => () end
end
