// This used to cause a type error in BPL <= 1.4.2 because
// methods were incorrectly typechecked recursively. The
// final method movements refers to the variable movements,
// not to the method itself.

val bank-account =
  class
    local
      val balance = ref 0
    in
      method deposit (amount : Nat) : () =
        balance := !balance + amount

      method withdraw (amount : Nat) : Nat =
         balance := !balance - amount;
        !balance
    end
  end

val my-account = new bank-account

val extended-bank-account =
  class
    inherit bank-account
    method close : Nat =
      let
        val bal = self.withdraw 0
      in
        self.withdraw bal; bal
      end
  end

val my-account = new extended-bank-account

val bank-account-plus =
  class
    inherit 
      super = extended-bank-account
    in
      local
        val movements = ref 0
      in
        method deposit (amount : Nat) : () =
          movements := !movements + 1;
          super.deposit amount

        method withdraw (amount : Nat) : Nat =
          movements := !movements + 1;
          super.withdraw amount

        method movements : Nat =
          !movements
      end      
    end
  end
