//! bplc -l

// simple class (encapsulation of state)

type Counter =
  class
    method x : Ref <Nat>
    method get : Nat
//    method set : Nat -> ()
    method inc : ()
  end

function counter (i : Nat) : Counter =
  class
    local
      val () = write "Counter.new\n"
      val x = ref i
    in
      method x : Ref <Nat> = x
      method get : Nat = write "Counter.get\n"; !x
//    method set (i : Nat) : () = write "Counter.set\n"; x := i
      method inc : () = write "Counter.inc\n"; x := !x + 1
    end
  end

val c = new (counter 0)