// needs parameterized modules

interface EQ <a> =
  sig
    val eq? : (a,a) -> Bool
  end

module Assoc <k, v> (E : EQ <k>) =
struct

  local

    open System.List
    open E

  in

    type Assoc = List <( k, v )>

    val empty = Nil

    function insert (k : k, v : v, list : Assoc) : Assoc =
      Cons ( ( k, v), list )

    exception Lookup k // does this work?

    function lookup (k : k, list : Assoc) : v =
      case list of Nil       => throw (Lookup k)
                |  Cons cons => if eq? (cons.1.1, k) then cons.1.2
                                else lookup (k, cons.2)
      end

  end

end
