// will not pass the type-checker (yet)
// requires infinite (recursive) types
// bplc -n Visitor.bpl

let

// Die Typen Visitor und Expr sind verschrnkt rekursiv.

type Visitor =
  object
    method visit-nat : Expr -> ()
    method visit-add : Expr -> ()
  end
and
type Expr =
  object
    method value  : Nat
    method accept : Visitor -> ()
  end

type Expr2 =
  object
//    method arg1   : Expr
//    method arg2   : Expr
    method value  : Nat
    method accept : Visitor -> ()
  end

//

function nat (n : Nat) : Expr =
  object
    method value : Nat = n
    method accept (v : Visitor) : () =
      v.visit-nat (self)
  end

function add (expr1 : Expr, expr2 : Expr) : Expr =
  object
//    method arg1  : Expr = e1
//    method arg2  : Expr = e2
    method value : Nat  = expr1.value + expr2.value
    method accept (v : Visitor) : () =
      expr1.accept v; v.visit-add (self); expr2.accept v
  end

// NB. value is re-evaluated each time.

//

val pr =
  object
    method visit-nat (e : Expr) : () =
      System.IO.print (e.value)
    method visit-add (e : Expr) : () =
      write " + "
  end

val e = add (nat 4711, add (nat 815, nat 9))

in

System.IO.println (e.value);
e.accept pr;
write "\n"

end
