// currently fails with Loop exception, no idea if it's supposed to
// self: open recursion

// `self' refers to the object, on which the method was called.
// The recursive knot is tied at object creation time (late binding).

// Inefficient (?) version.

let

type Set-Counter =
  ( get = () -> Nat, set = Nat -> (), inc = () -> () )

// erst `rep', dann `self, using recursion

type Set-Counter-Class =
  ( get = Set-Counter -> () -> Nat, set = Set-Counter -> Nat -> (), inc = Set-Counter -> () -> () )

function set-counter-class rep : Set-Counter-Class =
  ( get    = \ self () => !rep.x,
    set    = \ self i  => rep.x := i,
    inc    = \ self () => self.set (self.get () + 1) )

function new-set-counter () : Set-Counter =
  let
    val method-table = set-counter-class ( x = ref 0 )
  in
    rec obj =>
      ( get = method-table.get obj,
        set = method-table.set obj,
        inc = method-table.inc obj )
  end

type Instr-Counter =
  ( get = () -> Nat, set = Nat -> (), inc = () -> (), accesses = () -> Nat )

type Instr-Counter-Class =
  ( get = Instr-Counter -> () -> Nat,
    set = Instr-Counter -> Nat -> (),
    inc = Instr-Counter -> () -> (),
    accesses = Instr-Counter -> () -> Nat )

function instr-counter-class rep : Instr-Counter-Class =
  let
    val super = set-counter-class rep
  in
  ( get      = super.get,
    set      = \ self i  => rep.a := !rep.a + 1; super.set self i,
    inc      = super.inc,
    accesses = \self () => !rep.a)
  end

function new-instr-counter () : Instr-Counter =
  let
    val method-table = instr-counter-class ( x = ref 0, a = ref 0 )
  in
    rec obj =>
      ( get = method-table.get obj,
        set = method-table.set obj,
        inc = method-table.inc obj,
        accesses = method-table.accesses obj )
  end

// erst `rep', dann `self, using back-patching

/*
function set-counter-class (rep  : Counter-Rep) (self : Ref Set-Counter) : Set-Counter =
  ( get    = \ () => !rep.x,
    set    = \ i  => rep.x := i,
    inc    = \ () => (!self).set ((!self).get () + 1) )

function new-set-counter () : Set-Counter =
  let
    val obj  = ref 0
    val obj' = set-counter-class ( x = ref 0 ) obj
  in
    obj := obj'; obj' // back-patching
  end
*/

in
let
  val c1 = new-instr-counter ()
  val c2 = new-instr-counter ()
in
  write (show (c1.inc ()));
  write (show (c2.get ()));
  write (show (c1.inc (); c2.inc (); c1.get ()));
  write (show (c2.get ()));

  write (show (c1.accesses ()));
  write (show (c2.accesses ()))
end
end
