/*
Eine einfache Mengenimplementierung: geordnete Listen ohne Duplikate.
*/

interface COMPARE <a> =
  sig
    val compare : (a, a) -> Ordering
  end

/*
type Elem = Nat

module Elem =
  struct
    val compare = Nat.compare
  end
*/

//module Unique-Ordered-List =
module Unique-Ordered-List <elem> (Elem : COMPARE <elem>) =
  struct
    type Elem = elem

    open List

    // mit Duplikateliminierung
    function merge (list1 : List <Elem>, list2 : List <Elem>) : List <Elem> =
      case (list1, list2) of
        (Nil, xs) 
      | (xs, Nil) => xs
      | (Cons (x1, xs1), Cons (x2, xs2)) =>
          case Elem.compare (x1, x2) of
            LT => Cons (x1, merge (xs1,   list2))
          | EQ => Cons (x1, merge (xs1,   xs2  ))
          | GT => Cons (x2, merge (list1, xs2  ))
          end
      end

    function merge-pairwise (lists : List <List <Elem>>) : List <List <Elem>> =
      case lists of 
         Nil                         => Nil
      |  Cons (xs, Nil)              => Cons (xs, Nil)
      |  Cons (xs1, Cons (xs2, xss)) => Cons (merge (xs1, xs2), merge-pairwise xss)
      end

    function merge-many (lists : List <List <Elem>>) : List <Elem> =
      case lists of 
         Nil            => Nil
      |  Cons (xs, Nil) => xs
      |  _              => merge-many (merge-pairwise lists)
      end

    function member? (x : Elem, list : List <Elem>) : Bool =
      case list of
        Nil          => false
      | Cons (y, xs) =>
          case Elem.compare(x, y) of
            LT => false
          | EQ => true
          | GT => member? (x, xs)
          end
      end
  end

//module Set =
module Set <elem> (Elem : COMPARE <elem>) =
  struct
    local
      type Elem = elem

//      module List = Unique-Ordered-List
      module List = Unique-Ordered-List <Elem> Elem
      open List

      data Set <a> = Ordered-list (List <a>)
    in
      type Set = Set <Elem>

      function to-ordered-list (set : Set) : List <Elem> =
        case set of Ordered-list xs => xs end

      val empty = Ordered-list Nil

      function single (x : Elem) : Set =
        Ordered-list (Cons (x, Nil))

      function union (set1 : Set, set2 : Set) : Set =
        Ordered-list (merge (to-ordered-list set1, to-ordered-list set2))

      function set (list : List <Elem>) : Set =
        Ordered-list (merge-many (map <Elem, List <Elem>> (fun x => Cons (x, Nil)) list))

      function empty? (set : Set) : Bool =
        case set of
          Ordered-list Nil => true
        | _                => false
        end

      function member? (x : Elem, set : Set) : Bool =
        List.member? (x, to-ordered-list set)

      // subset

    end // local
  end // Set
