/*

Flexible Arrays untersttzen Subskription in `log n' und knnen zustzlich
in konstanter Zeit vorne erweitert werden (amortisierte Laufzeit unter der
Voraussetzung, dass die Datenstruktur ephemer verwendet wird).

*/

module Flexible-Array =
struct
  data Array <a> = Null
                 | Zero    (Array <(a, a)>)
                 | One  (a, Array <(a, a)>)

  function map <a, b> (f : a -> b) : Array <a> -> Array <b> =
    fun (list : Array <a>) =>
      case list of
        Null        => Null
      | Zero xs     => Zero (map <(a, a), (b, b)> (fun (a1, a2) => (f a1, f a2)) xs)
      | One (x, xs) => One (f x, map <(a, a), (b, b)> (fun (a1, a2) => (f a1, f a2)) xs)
      end

  // Konstruktion flexibler Arrays.

  function nil <a : Type> : Array <a> = Null

  function cons <a> (x : a, list : Array <a>) : Array <a> =
    case list of
      Null        => One (x, Null)
    | Zero xs     => One (x, xs)
    | One (y, xs) => Zero (cons <(a, a)> ((x, y), xs))
    end

  function flexible-array <a> (n : Nat, map : Nat -> a) : Array <a> =
    if n == 0 then
      Null
    else if n % 2 == 0 then 
      Zero (       flexible-array <(a, a)> (n / 2, fun i => (map (2 * i),     map (2 * i + 1))))
    else 
      One  (map 0, flexible-array <(a, a)> (n / 2, fun i => (map (2 * i + 1), map (2 * i + 2))))

  function between (l : Nat, r : Nat) : Array <Nat> =
    flexible-array <Nat> (r + 1 - l, fun i => l + i)

  // Subskription.

  function index <a> (list : Array <a>, i : Nat) : a =
    case list of
      Null        => throw Index
    | Zero xs     => if i % 2 == 0 then (index <(a, a)> (xs, i / 2)).1
                                   else (index <(a, a)> (xs, i / 2)).2
    | One (x, xs) => if i == 0 then x else index <a> (Zero xs, i - 1)
    end

  // Lnge

  function length <a> (list : Array <a>) : Nat =
    case list of
      Null        => 0
    | Zero xs     =>     2 * length <(a, a)> xs
    | One (_, xs) => 1 + 2 * length <(a, a)> xs
    end

  // Konversion (Listen in flexible Arrays und umgekehrt).

  local
    open List

    function unpairs <a> (list : List <(a, a)>) : List <a> =
      case list of
        Nil               => Nil
      | Cons ((x, y), xs) => Cons (x, Cons (y, unpairs <a> xs)	)
      end
  in
    function from-list <a> (list : List <a>) : Array <a> =
      fold <a, Array <a>> (nil <a>, cons <a>) list

    function to-list <a> (list : Array <a>) : List <a> =
      case list of
        Null        => Nil
      | Zero xs     => unpairs <a> (to-list <(a, a)> xs)
      | One (x, xs) => Cons (x, unpairs <a> (to-list <(a, a)> xs))
      end
  end

/*
  function reduce <a> (one : a, mul : (a, a) -> a) : Array <a> -> a =
    fun (list : Array <a>) =>
      case list of
        Null        => one
      | Zero xs     => mul (reduce <(a, a)> ((one, one), fun (a1, a2) => (mul a1, mul a2)) xs)
      | One (x, xs) => mul (x, mul (reduce <(a, a)> ((one, one), fun (a1, a2) => (mul a1, mul a2)) xs))
      end
*/

  function reduce <a> (one : a, mul : (a, a) -> a) : Array <a> -> a =
    let
      function red <b> (f : b -> a, list : Array <b>) : a =
        case list of
          Null        => one
        | Zero xs     =>           red <(b, b)> (fun (b1, b2) => mul (f b1, f b2), xs)
        | One (x, xs) => mul (f x, red <(b, b)> (fun (b1, b2) => mul (f b1, f b2), xs))
        end
    in 
      fun list => red <a> (fun x => x, list)
    end

  // function reduce-left
  // function reduce-right
end // Flexible-Array
