module Array-Ext =
struct
  function map <a, b> (f : a -> b) : Array <a> -> Array <b> =
    fun (a : Array <a>) => array [size a] i => f (a.[i])

  function member (s : String, a : Array <String>) : Bool =
    let
      function m (i : Nat) : Bool =
        if i == size a then false
                       else s == a.[i] || m (i + 1)
    in
      m 0
    end

  function reduce-right <a, b> (f : (a, b) -> b) : (Array <a>, b) -> b =
    fun (arr : Array <a>, x : b) =>
      let
        function red (i : Nat, x : b) : b =
          if i == size arr then x
                           else f (arr.[i], red (i + 1, x))
      in
        red (0, x)
      end

  function reduce-left <a, b> (f : (a, b) -> a) : (a, Array <b>) -> a =
    fun (x : a, arr : Array <b>) =>
      let
        function red (x : a, i : Nat) : a =
          if i == size arr then x
                           else red (f (x, arr.[i]), i + 1)
      in
        red (x, 0)
      end

  function intersperse (sep: String, a : Array <String>) : String =
    let
      function cat (i : Nat) : String =
        if i == size a then ""
                       else sep ^ a.[i] ^ cat (i + 1)
    in
      if      size a == 0 then ""
      else if size a == 1 then a.[0]
                          else a.[0] ^ cat 1
    end
end // Array-Ext
