// bplc Tree.bpl
let

data Tree <a> = Empty | Node ( left = Tree <a>, label = a, right = Tree <a> )

function leaf <a> (elem : a) : Tree <a> =
  Node ( left = Empty, label = elem, right = Empty )

val ex =
  Node (  left   =  leaf <Nat> 1,
          label  =  2,
          right  =  Node (  left   =  Empty,
                            label  =  3,
                            right  =  leaf <Nat> 4 ))

function insert <a> (ord  : (a, a) -> Bool)
                    (elem : a,
                     tree : Tree <a>) : Tree <a> =
  case tree  of  Empty      =>  leaf <a> elem
              |  Node node  =>
                 if ord (elem, node.label)
                 then  Node (  left   =  insert <a> ord (elem, node.left   ),
                               label  =  node.label,
                               right  =  node.right                            )
                 else  Node (  left   =  node.left,
                               label  =  node.label,
                               right  =  insert <a> ord (elem, node.right  )  )
   end

in
insert <Nat> (\ (x1, x2) => x1 =< x2) (2, ex)
end