// bplc Self0.bpl

// self: closed recursion

// `self' refers to the current class/object. The recursive knot
// is tied at class definition time.

let

type Set-Counter =
  ( get = () -> Nat, set = Nat -> (), inc = () -> () )

type Counter-Rep = ( x = Ref <Nat> )

function set-counter-class (rep : Counter-Rep) : Set-Counter =
  rec (self : Set-Counter) =>
  ( get    = \ () => !rep.x,
    set    = \ i  => rep.x := i,
    inc    = \ () => self.set (self.get () + 1) )

function new-set-counter () : Set-Counter =
  set-counter-class ( x = ref 0 )

function max (m : Nat, n : Nat) : Nat =
  if m > n then m else n

// the subclass illustrates why closed recursion is a bad idea

type Maximum-Counter-Rep = ( x = Ref <Nat>, m = Ref <Nat> )

type Maximum-Counter =
  ( get = () -> Nat, set = Nat -> (), inc = () -> (), maximum = () -> Nat )

function maximum-counter-class (rep : Maximum-Counter-Rep) : Maximum-Counter =
  let
    val super = set-counter-class rep
  in
    rec (self : Set-Counter) =>
    ( get      = super.get,
      set      = \ i  => rep.m := max (!rep.m, i); super.set i,
      inc      = super.inc,
      maximum  = \ () => !rep.m)
  end

type Instr-Counter =
  Maximum-Counter

function new-maximum-counter () : Instr-Counter =
  maximum-counter-class ( x = ref 0, m = ref 0 )

//

in
let
  val c1 = new-maximum-counter ()
  val c2 = new-set-counter ()
in
  write (show (c1.inc ()));
  write (show (c2.get ()));
  write (show (c1.inc (); c2.inc (); c1.get ()));
  write (show (c2.get ()));
  write (show (c1.maximum ()))
end
end