// bplc shared.bpl
let

data Coroutine = Cor (Cont <Coroutine>)
// Beachte: Coroutine ist rekursiv definiert.

function unroll (cor : Coroutine) : Cont <Coroutine> =
  case cor of Cor k => k end

// resume : Coroutine -> Coroutine
function resume (cor : Coroutine) : Coroutine =
  letcc self : Cont <Coroutine> in continue (unroll cor) (Cor self) end
// Aufruf einer Coroutine mit der eigenen Fortsetzung.

// callcc : (Coroutine -> Coroutine) -> Coroutine
function callcc (f : Coroutine -> Coroutine) : Coroutine =
  letcc self : Cont <Coroutine> in f (Cor self) end

// Was macht ????

function bounce () : Coroutine = 
  callcc (\ c => c)
// Terminiert `partnera' mit `bounce' in `partnerb (callcc partnera)',
// dann wird `partnerb' von vorne ausgefuehrt!?!?!?!?!?!?!?!??!?!?!?!?

// Beispiel 1

function partnera (b0 : Coroutine) : Coroutine =
  write "a: part 1\n";
  let val b1 = resume b0 in
  write "a: part 2\n";
  let val b2 = resume b1 in
  write "a: part 3\n";
  partnera b2 
  end end

function partnerb (a0 : Coroutine) : () =
  write "b: part 1\n";
  let val a1 = resume a0 in
  write "b: part 2\n";
  write "b: part 3\n";
  let val a2 = resume a1 in
  () // partnerb a2 
  end end

// Beispiel 2: Producer/Consumer. Eine `shared variable' dient zur
// Kommunikation zwischen den Coroutinen.

val buffer = ref 0 

function produce (n : Nat) (cor : Coroutine) : Coroutine =
  buffer := n; 
  produce (n + 1) (resume cor)

function consume (pro : Coroutine) : String =
  System.IO.println (!buffer);
  if !buffer > 99 then "done" else consume (resume pro)

in

// Beispiel 1:
partnerb (callcc partnera)
// `partnera' bekommt `partnerb' mit auf dem Weg; `partnera' startet;
// `partnerb' terminiert die Interaktion.

// partnerb (bounce ())

// Beispiel 2:
// consume (callcc (produce 0))

end