// bplc -l Coroutine.bpl gray.bpl

/*
Eine funktionale Realisierung von Knuths Gray-Code Generatoren.
*/

let

module List = System.List
open List

type Gen <a> = () -> a

val more = ref true

val nil : Gen <List <Nat>> =
  Coroutine.define (\ yield =>
    \ () =>
      System.Control.forever (\ () =>
        more := true;
        yield Nil;
        more := false;
        yield Nil))

function bit (g : Gen <List <Nat>>) : Gen <List <Nat>> =
  Coroutine.define (\ yield =>
    \ () =>
      System.Control.forever (\ () =>
        let val as = g () in
        yield (List.Cons (0, as));
        yield (List.Cons (1, as))
        end ))

// Die nchste Liste ndert sich hchstens in einem Element.

function gray (g : Gen <List <Nat>>) : Gen <List <Nat>> =
  Coroutine.define (\ yield =>
    \ () =>
      System.Control.forever (\ () =>
        let val as = g () in
        yield (List.Cons (0, as));
        yield (List.Cons (1, as));
        let val as' = g () in
        yield (List.Cons (1, as'));
        yield (List.Cons (0, as'))
        end end))

// Die Endlosschleife von `bit' wird im Prinzip einmal
// aufgerollt und die Folge 0,1,0,1 durch 0,1,1,0 ersetzt.

// binrer Zhler (90 gedreht)
// --------########
// ----####----####
// --##--##--##--##
// -#-#-#-#-#-#-#-#

val b4 = bit (bit (bit (bit nil)))

// Gray-Code (90 gedreht)
// --------################--------
// ----########--------########----
// --####----####----####----####--
// -##--##--##--##--##--##--##--##-

val g4 = gray (gray (gray (gray nil)))

function printgen <a> (g : Gen <List <a>>) : () =
  let
    val bs = ref (g ())
  in
    while !more do
      List.print System.IO.print (!bs);
      write "\n";
      bs := g ()
    end
  end
// System.Control.for (0, 15) (\ i =>
//   List.print System.IO.print (g ()); write "\n");


in

printgen b4;
write "----\n";
printgen g4

end