// bplc -i -l Coroutine.bpl
module Coroutine =
struct
  // val () = write "Loading <Coroutine> ..\n"

  function define <a,b> (maker : (b -> a) -> (a -> b)) : (a -> b) =
    letcc client : Cont <a -> b> in
      let
        val callee = System.Cont.alloc <a>
        val caller = System.Cont.alloc <b>
        val yield  = \ b => letcc callee' : Cont <a> in callee := callee'; continue (!caller) b end
        val resume = \ a => letcc caller' : Cont <b> in caller := caller'; continue (!callee) a end
        val b = (maker yield) 
                   (letcc callee' : Cont <a> in 
                      callee := callee'; continue client resume end)
      in
        continue (!caller) b
      end
    end
end