// bplc Ref.bpl

let

type Reference <a> =
  class
    method get : a
    method set : a -> ()
  end

function reference <a> (x : a) : Reference <a> =
  class
    local
      val r = ref x
    in
      method get : a = !r
      method set (y : a) : () = r := y
    end
  end

val x = new (reference <Nat> 4711)

in
System.IO.println (x.get);
x.set 815;
System.IO.println (x.get)
end