// will not parse
let

class Counter () =
  object
    val () = write "Counter.new\n"
    local
      val x = ref 0
    in
      method get () : Nat = write "Counter.get\n"; !x
      method set (i : Nat) : () = write "Counter.set\n"; x := i
      method inc () : () = write "Counter.inc\n"; x := !x + 1
    end
  end

/*
class Reset-Counter () =
  object
    inherit Counter ()
    method reset () : () = self.set 0
  end

class Inc-Counter () =
  object
    val () = write "I.new\n"
    inherit Counter ()
    method inc () : () = write "I.inc\n"; self.set (self.get () + 1)
  end
*/

class Backup-Counter () =
  object
    val () = write "Backup-Counter.new\n"
    inherit super = Counter ()
    local
      val b = ref 0
    in
      method set (i : Nat) : () = write "Backup-Counter.set\n"; b := self.get(); super.set i
      method restore () : () = write "Backup-Counter.restore\n"; super.set (!b)
    end
  end

val c = new Backup-Counter ()

// open System.IO

in
c.inc();
c.inc();
// println (c.get())
write (show (c.get()) + "\n");
c.set 7;
write (show (c.get()) + "\n")
end