// The Tak benchmark is John McCarthy's mis-remembered
// version of the Takeuchi function.

// A recursive function devised by I. Takeuchi in 1978
// (Knuth 1998).

let  

  val n = ref 0

  function tak (x : Nat, y : Nat, z : Nat) : Nat =
       n := !n + 1;
       if x =< y then z
                 else tak (tak (x - 1, y, z),
                           tak (y - 1, z, x),
                           tak (z - 1, x, y))
in  
  tak(18, 12, 6); // original: 63609 steps
//  tak(36, 24, 12); // too long
//  tak(21, 14, 7); // 395757 steps
//  tak(24, 16, 8); // 2493349 steps
  !n
end