let

  val f = rec (f : (even = Nat -> Bool, odd = Nat -> Bool)) =>
            ( even = \ (n : Nat) => n == 0 || f.odd  (n - 1),
              odd  = \ (n : Nat) => n /= 0 && f.even (n - 1) )

  val g = rec (even = even : Nat -> Bool, odd = odd : Nat -> Bool) =>
            ( even = \ (n : Nat) => n == 0 || odd  (n - 1),
              odd  = \ (n : Nat) => n /= 0 && even (n - 1) )

  val (even = even : Nat -> Bool, odd = odd : Nat -> Bool) =
    rec (even = even : Nat -> Bool, odd = odd : Nat -> Bool) =>
      ( even = \ (n : Nat) => n == 0 || odd  (n - 1),
        odd  = \ (n : Nat) => n /= 0 && even (n - 1) )

  val h = rec (even : Nat -> Bool, odd : Nat -> Bool) =>
            ( \ (n : Nat) => n == 0 || odd  (n - 1),
              \ (n : Nat) => n /= 0 && even (n - 1) )

in
System.IO.println (f.even 9);
System.IO.println (f.even 8);
System.IO.println (f.odd 9);
System.IO.println (f.odd 8);

System.IO.println (g.even 9);
System.IO.println (g.even 8);
System.IO.println (g.odd 9);
System.IO.println (g.odd 8);

System.IO.println (even 9);
System.IO.println (even 8);
System.IO.println (odd 9);
System.IO.println (odd 8);

System.IO.println (h.1 9);
System.IO.println (h.1 8);
System.IO.println (h.2 9);
System.IO.println (h.2 8)
end