let

data List <a> = Nil | Cons ( head = a, tail = List <a> )

function length <a> (list : List <a>) : Nat =
  case list  of  Nil        =>  0
             |   Cons cons  =>  1 + length <a> (cons.tail)
  end

// mit geschachteltem case
function merge <a> (ord : (a, a) -> Bool)
                   (xs1 : List <a>, 
                    xs2 : List <a>) : List <a> =
  case xs1 of
    Nil => xs2
  | Cons ( head = h1, tail = t1 ) => 
      case xs2 of
         Nil => xs1
      |  Cons ( head = h2, tail = t2 ) =>
        if ord (h1, h2)  then  Cons ( head = h1, tail = merge <a> ord (t1,   xs2  ) )
                         else  Cons ( head = h2, tail = merge <a> ord (xs1,  t2   ) )
      end
  end

// mit geschachtelten Mustern
function merge <a> (ord : (a, a) -> Bool)
                   (xs1 : List <a>, 
                    xs2 : List <a>) : List <a> =
  case (xs1, xs2) of
    (Nil, _) => xs2
  | (_, Nil) => xs1
  | (Cons ( head = h1, tail = t1 ), Cons ( head = h2, tail = t2 )) =>
        if ord (h1, h2)  then  Cons ( head = h1, tail = merge <a> ord (t1,   xs2  ) )
                         else  Cons ( head = h2, tail = merge <a> ord (xs1,  t2   ) )
  end

function fromto (lower : Nat, upper : Nat) : List <Nat> =
  if lower ># upper then Nil
                    else Cons ( head = lower, tail = fromto (lower + 1, upper))

in
merge <Nat> (\ (x1, x2) => x1 =< x2) (fromto (0, 9), fromto (0, 9))
end
