// self and open recursion

let

// closed recursion: self refers to the current class/object

type Set-Counter = ( get = () -> Nat, set = Nat -> (), inc = () -> () )

type Counter-Rep = ( x = Ref <Nat> )

function set-counter-class (rep : Counter-Rep) : Set-Counter =
  rec (self : Set-Counter) =>
  ( get    = \ () => !rep.x,
    set    = \ i  => rep.x := i,
    inc    = \ () => self.set (self.get () + 1) )

function new-set-counter () : Set-Counter =
  set-counter-class ( x = ref 0 )

// open recursion: self refers to the object, on which the method was called
// Requires bounded-recursion; uses references, back-patching and the
// covariant Source type.

exception Null

/*
function set-counter-class
  <r> // eigentlich r <: Counter-Rep
  (self : Source <r -> Set-Counter>)
  (rep  : r) : Set-Counter =
  ( get    = \ () => !rep.x,
    set    = \ i  => rep.x := i,
    inc    = \ () => ((!self) rep).set (((!self) rep).get () + 1) )

val new-set-counter =
  let
  // class table wird einmal statisch allokiert
    val obj  = ref (\ rep => throw Null)
    val obj' = set-counter-class <Counter-Rep> obj
  in
  obj := obj'; // back-patching
  \ () => obj' ( x = ref 0 )
  end
*/

in
let
  val c1 = new-set-counter ()
  val c2 = new-set-counter ()
in
  System.IO.println (c1.inc ());
  System.IO.println (c2.get ());
  System.IO.println (c1.inc (); c2.inc (); c1.get ());
  System.IO.println (c2.get ())
end
end