// object with an internal state (encapsulation)

let

// interface

type Counter = ( get = () -> Nat, inc = () -> () )

// stand-alone object

val counter =
    let val x = ref 0 in                // private (instance variables)
      ( get  = \ () => !x,              // public (methods)
        inc  = \ () => x := !x + 1 )
    end

// object generator (aka new)

function new-counter () : Counter =
    let val x = ref 0 in                // private (instance variables)
      ( get = \ () => !x,              // public (methods)
        inc = \ () => x := !x + 1 )
    end

function inc3 (c : Counter) : Nat =
  c.inc (); c.inc (); c.inc (); c.get ()

open System.IO

in
println (counter.inc ());
println (counter.get ());
println (counter.inc (); counter.inc (); counter.get ());

let
  val c1 = new-counter ()
  val c2 = new-counter ()
in
  println (c1.inc ());
  println (c2.get ());
  println (c1.inc (); c2.inc (); c1.get ());
  println (inc3 c1);
  println (inc3 c2)
end
end