let

  module Counter =
    struct
      local
        val x = ref 0
      in
        function get () : Nat = !x
        function set i  : ()  = x := i
        function inc () : ()  = x := !x +1
      end
    end

  module Backup-Counter =
    struct
      local
        val b = ref 0
      in
        open Counter  // inheritance
        function backup  () : () = b := get()
        function restore () : () = set (!b)
      end
    end

  module Counter = Backup-Counter

  open System.IO

in
// `Counter.x' is not visible here
Counter.inc();
Counter.inc();
Counter.backup();
Counter.inc();
Counter.inc();
println (Counter.get ());
Counter.restore();
println (Counter.get ())
end