// another test for qualified name handling

open List

data Power-List <a> = Null
                    | Zero    (Power-List <(a, a)>)
                    | One  (a, Power-List <(a, a)>)

// construction

val nil = Null

function cons <a> (x : a, list : Power-List <a>) : Power-List <a> =
  case list of
    Null        => One (x, Null)
  | Zero xs     => One (x, xs)
  | One (y, xs) => Zero (cons <(a, a)> ((x, y), xs))
  end

function from-list <a> (list : List.List <a>) : Power-List <a> =
  List.fold <a, Power-List <a>> (nil, cons <a>) list

// access

function index <a> (list : Power-List <a>, i : Nat) : a =
  case list of
    Null        => throw Index
  | Zero xs     => if i % 2 == 0 then (index <(a, a)> (xs, i / 2)).1
                                 else (index <(a, a)> (xs, i / 2)).2
  | One (x, xs) => if i == 0 then x else index <a> (Zero xs, i - 1)
  end

// conversion

function unpairs <a> (list : List.List <(a, a)>) : List.List <a> =
  case list of
    Nil               => Nil
  | Cons ((x, y), xs) => Cons (x, Cons (y, unpairs <a> xs))
  end

function to-list <a> (list : Power-List <a>) : List.List <a> =
  case list of
    Null        => Nil
  | Zero xs     => unpairs <a> (to-list <(a, a)> xs)
  | One (x, xs) => Cons (x, unpairs <a> (to-list <(a, a)> xs))
  end
