//! bplc -l Coroutine.bpl

let

open System.List

val make = \ <a> (x : a) (xs : List <a>) => Cons ( x, xs )

function revto <a> (front, rear) : List <a> =
  case front of
    Nil       => rear
  | Cons cons => revto <a> (cons.2, make cons.1 rear)
  end

data Maybe <a> = Nothing | Just a
type Gen <a> = () -> Maybe <a>

function foreach <a> (gen : Gen <a>) (action : a -> ()): () =
  case gen () of
    Nothing => ()
  | Just x  => action x; foreach <a> gen action
  end

///////////////////////////////////////////////////////////////////////////////

// elements of a list

// state

function elements <a> (root : List <a>) : Gen <a> =
  Coroutine.define (\ yield =>
    fun () =>
      System.List.foreach <a> root (\ elem => yield (Just elem));
      Nothing
  )

// coroutine

function elements' <a> (root : List <a>) : Gen <a> =
  let val xs = ref root
  in
    fun () =>
      case !xs of
        Nil       => Nothing
      | Cons cons => xs := cons.2; Just (cons.1)
      end
  end

///////////////////////////////////////////////////////////////////////////////

function sublists <a> (root : List <a>) : Gen <List <a>> =
  Coroutine.define (\ yield =>
    fun () =>
      case root of
        Nil       => yield (Just Nil)
      | Cons cons => foreach <List <a>> (sublists <a> (cons.2)) (\ xs =>
                       yield (Just xs);
                       yield (Just (make cons.1 xs))
                     )
      end;
      Nothing
  )

///////////////////////////////////////////////////////////////////////////////

function permutations <a> (root : List <a>) : Gen <List <a>> =
  Coroutine.define (\ yield =>
    fun () =>
      case root of
        Nil       => yield (Just Nil)
      | Cons cons => foreach <List <a>> (permutations <a> (cons.2)) (\ xs =>
                       let function insertions (left, right) : () =
                             yield (Just (revto <a> (left, make cons.1 right)));
                             case right of
                               Nil       => ()
                             | Cons cons => insertions (make cons.1 left, cons.2)
                             end
                       in
                         insertions (Nil, xs)
                       end
                     )
      end;
      Nothing
  )

///////////////////////////////////////////////////////////////////////////////

val n = ref 0

in

// System.IO.println (revto <Nat> (Nil, between (0, 9))); 

//System.List.foreach <Nat> (between (0, 9)) (\ x =>
//foreach <Nat> (elements' <Nat> (between (0, 9))) (\ x =>
//foreach <Nat> (sublists <Nat> (between (0, 3))) (\ x =>
foreach <List <Nat>> (permutations <Nat> (between (0, 3))) (\ x =>
  System.IO.println (x); 
//  print System.IO.print x; write "\n";
  n := !n + 1
);
System.IO.println (!n)

end
