//! bplc -l
module Stack =
struct

  open System.List

  type Stack <a> =
    class
      method empty : Bool
      method push  : a -> ()
      method pop   : a
      method top   : a
    end

  exception Pop
  exception Top

  function stack <a> : Stack <a> =
    class
      local
        val s = ref Nil
      in
        method empty : Bool =
          case !s of
            Nil    => true
          | Cons c => false
          end
        method push (x : a) : () =
          s := Cons ( x, !s )
        method pop : a =
          case !s of
            Nil    => throw Pop
          | Cons c => s := c.2; c.1
          end
        method top : a =
          case !s of
            Nil    => throw Top
          | Cons c => c.1
          end
      end
    end

end