// self is only visible in methods, the use
// of self in local values should cause a static error

let

val counter =
  class
    local
      val n = ref 0
    in
      method inc : Nat =
        n := !n + 1; !n
      method dec : Nat =
        n := !n - 1; !n
    end
  end

function maximum  (a : Nat, b : Nat) : Nat =
  if a >= b then a else b

val max-counter =
  class
    inherit 
      super = counter
    in
      local
        val max = ref (self.inc; self.dec)
      in
        method inc : Nat =
          let
            val cur = super.inc
          in 
            max := maximum (!max, cur);
            cur
          end
      end      
    end
  end

in

new max-counter

end