// bplc Class-Variable.bpl

let

local

val n = ref 0

in

function instances () : Nat = !n

val counter = \ (i : Nat) =>
  class
    local
      val () = n := !n + 1; write ("Counter.new: " + show (!n) + "\n")
      val x = ref i
    in
      method get : Nat = write "Counter.get\n"; !x
      method set (i : Nat) : () = write "Counter.set\n"; x := i
      method inc : () = write "Counter.inc\n"; x := !x + 1
    end
  end

end

val c1 = new (counter 0)
val c2 = new (counter 0)
val c3 = new (counter 0)

// open System.IO

in
c1.get;
c1.inc;
write (show (c1.get) + "\n");
c1.inc;
// println (c1.get)
write (show (c1.get) + "\n");
write ("instances: " + show (instances ()) + "\n")
end