//! bplc -l Matrix.bpl

let

open Matrix

function sum (a : Array <Nat>) : Nat =
  let
    val s = ref 0
  in
    System.Control.for (0, size a - 1) (\ i =>
      s := !s + a.[i]
    );
    !s
  end

exception Mul

function mul (a : Matrix <Nat>, b : Matrix <Nat>) : Matrix <Nat> =
  let
    val (m,  p) = dim <Nat> a
    val (p', n) = dim <Nat> b
  in
    if p == p' then
      create <Nat> (m, n) (\ (i, j) =>
        sum (array [p] k => index <Nat> a (i, k) * index <Nat> b (k, j))
      )
    else
      throw Mul
  end

val a = matrix <Nat> [[4, 3, 1], [1, 0, 1], [2, 1, 2], [1, 0, 2]]
val b = matrix <Nat> [[3, 1, 0], [2, 1, 0], [1, 1, 1]]

in
mul (a, b)
end