// will not pass the type-checker (yet)
// bplc -n Visitor.bpl

let

// Die Typen Visitor, Expr und BinExpr sind verschrnkt rekursiv.

type Visitor =
  object
    method visit-nat : Expr0 -> ()
    method visit-add : Expr2 -> ()
  end

//

type Expr =
  object
    method value_ : Nat
    method accept : Visitor -> ()
  end

type Expr0 = Expr

function nat (n : Nat) : Expr0 =
  new class
    method value_ : Nat = n
    method accept (v : Visitor) : () =
      v.visit-nat (self)
  end

type Expr2 =
  object
    method arg1   : Expr
    method arg2   : Expr
    method value_ : Nat
    method accept : Visitor -> ()
  end

function add (expr1 : Expr, expr2 : Expr) : Expr2 =
  new class
//    method arg1  : Expr = e1
//    method arg2  : Expr = e2
    method value_ : Nat  = expr1.value_ + expr2.value_
    method accept (v : Visitor) : () =
      expr1.accept v; v.visit-add (self); expr2.accept v
  end

// NB. value is re-evaluated each time.

//

val pr =
  new class
    method visit-nat (e : Expr0) : () =
      System.IO.print (e.value_)
    method visit-add (e : Expr2) : () =
      write " + "
  end

val e = add (nat 4711, add (nat 815, nat 9))

in

System.IO.println (e.value_);
e.accept pr;
write "\n"

end