// Booleans

//data Bool = False | True

//val false = False
//val true  = True

// Natural numbers

data Nat = Zero | Succ Nat

val zero = 0

function succ (n : Nat) : Nat =
  n + 1

function pred (n : Nat) : Nat =
  n - 1

function zero? (n : Nat) : Bool =
  n == 0

function add (m : Nat, n : Nat) : Nat =
  if zero? m then n
             else succ (add (pred m, n))

function sub (m : Nat, n : Nat) : Nat =
  if zero? n then m
             else sub (pred m, pred n)

function mul (m : Nat, n : Nat) : Nat =
  if zero? m then zero
             else add (n, mult (pred m, n))

// TODO: div, exp