module List-Ext =
struct
  open List

  exception Head
  function head <a> (list : List <a>) : a =
    case list of
      Nil         => throw Head
    | Cons (x, _) => x
    end

  exception Tail
  function tail <a> (list : List <a>) : List <a> =
    case list of
      Nil          => throw Tail
    | Cons (_, xs) => xs
    end

  function reduce-right <a, b> (f : (a, b) -> b) : (List <a>, b) -> b =
    rec fun red (list : List <a>, x : b) : b =>
      case list of
        Nil          => x
      | Cons (a, as) => f (a, red (as, x))
//      | Cons (a, as) => red (as, f (a, x)) // wrong order
      end
  // reduce-right (fun (m, n) => m + n) (between (1, 10), 0)
  // reduce-right (fun (m, n) => m * n) (between (1, 10), 1)
  // reduce-right (fun (m, n) => Cons (m, n)) (between (1, 10), Nil)

  function reduce-left <a, b> (f : (a, b) -> a) : (a, List <b>) -> a =
    rec fun red (x : a, list : List <b>) : a =>
      case list of
        Nil          => x
      | Cons (b, bs) => red (f (x, b), bs)
//      | Cons (b, bs) => f (red (x, bs), b) // wrong order
      end

  function index <a : Type> (list : List <a>, n : Nat) : a =
    case list of
      Nil          => throw Index
    | Cons (x, xs) => if n == 0 then x else index <a> (xs, n - 1)
    end

  function all <a : Type> (prop : a -> Bool) : List <a> -> Bool =
    rec fun test (ns : List <a>) : Bool =>
      case ns of Nil           => true
              |  Cons (n, ns') => prop n && test ns'
              end

  function any <a : Type> (prop : a -> Bool) : List <a> -> Bool =
    rec fun test (ns : List <a>) : Bool =>
      case ns of Nil           => false
              |  Cons (n, ns') => prop n || test ns'
              end

  function between-step (l : Nat, l': Nat, u : Nat) : List <Nat> =
    if l #< l' then
      let val d = l' - l in
        (rec fun up (i : Nat) : List <Nat> =>
          if i ># u  then  Nil
                     else  Cons (i, up (i + d))) l
      end
    else
      let val d = l - l' in
        (rec fun down (i : Nat) : List <Nat> =>
          if i #< u  then  Nil
                     else  Cons (i, down (i - d))) l
      end

  function to-array <a> (xs : List <a>) : Array <a> =
    let
      val list = ref xs
    in
      array [length xs] i =>
        case !list of
          Cons (x, xs) => list := xs; x
        end
    end
end // List-Ext
