module Array-Ext =
struct
  function map <a, b> (f : a -> b) : Array <a> -> Array <b> =
    fun (a : Array <a>) => array [size a] i => f (a.[i])

  function member (s : String, a : Array <String>) : Bool =
    let
      function m (i : Nat) : Bool =
        if i == size a then false
                       else s == a.[i] || m (i + 1)
    in
      m 0
    end

  function intersperse (sep: String, a : Array <String>) : String =
    let
      function cat (i : Nat) : String =
        if i == size a then ""
                       else sep ^ a.[i] ^ cat (i + 1)
    in
      if      size a == 0 then ""
      else if size a == 1 then a.[0]
                          else a.[0] ^ cat 1
    end
end // Array-Ext
