// bplc List.bpl
let

/*
type Link <a> = Ref <List <a>>

data List <a> = Nil | Cons ( head = a, tail = Link <a> )
*/

data List <a> = Nil | Cons ( head = a, tail = Ref <List <a>> )

type Link <a> = Ref <List <a>>

function insert (a : Nat, link : Link <Nat>) : () =
  case !link  of  Nil        =>  link := Cons ( head = a, tail = ref Nil )
              |   Cons cons  =>  if a =< cons.head
                                 then  link := Cons ( head = a, tail = link )
                                 else  insert (a, cons.tail)
  end

in
0
end
