// bplc Account.bpl
let

type Account = (  deposit   =  Nat -> (),
                  withdraw  =  Nat -> (),
                  balance   =  () -> Nat )

exception Insufficient Nat

function newAccount (n : Nat) : Account =
  let  val bal = ref n
  in   (  deposit   =  fun (d : Nat) => bal := !bal + d,
          withdraw  =  fun (d : Nat) =>  
                         let  val n' = !bal - d
                         in   if 0 > n' then  throw (Insufficient d)
                                        else  bal := n'
                         end,
          balance   =  fun () => !bal )
  end

val myaccount = newAccount (100)

in
  try  
    myaccount.withdraw (50);
    myaccount.withdraw (60);
    myaccount.deposit (40);
    myaccount.withdraw (60);
    write ("OK.")
  catch Insufficient d =>
    write ("Insufficient funds!\n");
    write ("  Can't withdraw "); write (show (d)); write ("$.\n")
  end
end
