let

data Ordering = LT | EQ | GT

interface ORD <a> =
  sig
    val compare : (a, a) -> Ordering
  end

module Flip <a> (Ord : ORD <a>) =
  struct
    function compare (x : a, y : a) : Ordering =
      case Ord.compare (x, y) of
        LT => GT
      | EQ => EQ
      | GT => LT
      end
  end

interface SET <a> =
  sig
//    data Set
    val empty : Set
    val single : a -> Set
    val insert : (a, Set) -> Set
  end

module Set <a> (Ord : ORD <a>) =
  struct

    data Set = Empty | Node ( left = Set, label = a, right = Set )

    val empty = Empty

    function single (elem : a) : Set =
      Node ( left = Empty, label = elem, right = Empty )
    
    function insert (elem : a, tree : Set) : Set =
      case tree  of  Empty      =>  single elem
                  |  Node node  =>
                       case Ord.compare (elem, node.label) of
                         LT => Node ( left   =  insert (elem, node.left),
                                      label  =  node.label,
                                      right  =  node.right)
                       | EQ => tree
                       | GT => Node ( left   =  node.left,
                                      label  =  node.label,
                                      right  =  insert (elem, node.right))
                       end
      end

  end

module Nat =
  struct
    function compare (a : Nat, b : Nat) : Ordering =
      if a ># b then GT
      else if a == b then EQ
      else LT
  end

module S = Set <Nat> Nat
// module S = Set <Nat> (Flip <Nat> Nat)

val root = ref S.empty

in
root := S.insert (1, S.insert (2, S.insert (2, S.empty)));
System.Control.for (0, 9) (\ i =>
  root := S.insert (i, !root));
!root
end
  