let

interface ORD <a> =
  sig
    val compare : (a, a) -> Ordering
  end

module Flip <a> (Ord : ORD <a>) =
  struct
    function compare (x : a, y : a) : Ordering =
      Ord.compare (y, x)
/*
      case Ord.compare (x, y) of
        LT => GT
      | EQ => EQ
      | GT => LT
      end
*/
  end

interface SET <a> =
  abstract <set> in
    sig
      type Set   = set
      val empty  : Set
      val single : a -> Set
      val insert : (a, Set) -> Set
    end

module Set <a> (Ord : ORD <a>) : SET <a> =
  struct
    data Set = Empty | Node (Set, a, Set)

    val empty = Empty

    function single (elem : a) : Set =
      Node (Empty, elem, Empty )
    
    function insert (elem : a, tree : Set) : Set =
      case tree of
        Empty                  => single elem
      | Node (left, x, right)  =>
          case Ord.compare (elem, x) of
            LT => Node (insert (elem, left), x, right)
          | EQ => tree
          | GT => Node (left, x, insert (elem, right))
          end
      end

  end

module S = Set <Nat> Nat
// module S = Set <Nat> (Flip <Nat> Nat)

val root = ref S.empty

in
root := S.insert (1, S.insert (2, S.insert (2, S.empty)));
System.Control.for (0, 9) (\ i =>
  root := S.insert (i, !root));
!root
end
  