// bplc while.bpl
let

type Block<a> = () -> a

val skip = ()

function while`do`end (test : Block<Bool>) (body : Block<()>) : () =
  if value test then
    value body ; 
    while` test `do` body `end
  else
    skip

function repeat`until`end (body : Block<()>) (test : Block<Bool>) : () =
  value body ; 
  if value test then
    skip
  else
    repeat` body `until` test `end

function repeat (test : Block<Bool>) : () =
  if value test then
    skip
  else
    repeat test

function loop`if`exit`end (body1 : Block<()>) (test : Block<Bool>) (body2 : Block<()>) : () =
  value body1 ; 
  if value test then
    skip
  else
    value body2 ;
    loop` body1 `if` test `exit` body2 `end

// Die Alternative lsst sich wegen des Typparameters nicht so elegant
// definieren. Hier: if`then`else als Anweisung (vom Typ `()').

function if`then`else`fi (test : Bool) (t : Block<()>) (e : Block<()>) : () =
  if test then value t else value e

function for`do`end (lower : Nat, upper : Nat) (body : Nat -> ()) : () =
  if lower > upper then ()
                   else body lower;
                        for` (lower + 1, upper) `do` body `end

val i = ref 0

in

while` { 9 > !i } `do` 
{
    write "Hello, world!\n";
    i := !i + 1
} 
`end;

i := 0;

repeat`
{
    write "Hello, world!\n"
} `until` { i := !i + 1; !i > 9 } `end;

i := 0;

repeat`
{
    ()
} `until` { write "Hello, world!\n"; i := !i + 1; !i > 9 } `end;

i := 0;

repeat
{
    write "Hello, world!\n";
    i := !i + 1;
    !i > 9
};

repeat
{
    write "Hello, world!\n";
    true // false
};

i := 0;

loop` {
  write "Hello, "
} `if` { i := !i + 1; !i > 9 } `exit` {
  write "world!\n"
} `end;

if` 2 > 5 `then` {
  write "uups\n"
} `else` {
  write "jau\n"
} `fi;

for` (0, 9) `do` \ i =>
  write (show i + "\n")
`end

end
