// bplc Priority-Queue.bpl

let

open List

type Priority-Queue <a> =
  class
    method insert : a -> ()
    method delete : a
  end

exception Delete

function ordlist <a> (ord : (a, a) -> Bool) : Priority-Queue <a> =
  class
    local
      val queue = ref Nil
    in
      method insert (elem : a) : () =
        let
          function ins (list : List <a>) : List <a> =
            case list of Nil       => Cons ( elem, Nil )
                      |  Cons cons => if ord (elem, cons.1) 
                                      then Cons ( elem, list )
                                      else Cons ( cons.1, ins (cons.2) )
            end
        in
          queue := ins (!queue)
        end
      method delete : a =
        case !queue of Nil       => throw Delete
                    |  Cons cons => queue := cons.2; cons.1
        end
    end
  end

val q = new (ordlist <Nat> (\ (m, n) => m > n ))

in
q.insert 815;
q.insert 4711;
q.insert 0;
System.IO.println (q.delete);
System.IO.println (q.delete);
System.IO.println (q.delete)
end